$(document).ready(function() {

	var isMobile = navigator.userAgent.match(/(iPad)|(iPhone)|(iPod)|(android)|(webOS)/i);

    $('.close-contact, .right-side .trigger-contact').on('click', function(event) {
        event.preventDefault();
        $('.main-wrapper').toggleClass('opens-contact');
	});

    $('.close-about, .right-side .trigger-about').on('click', function(event) {
        event.preventDefault();
        $('.main-wrapper').toggleClass('opens-about');
    });

    $('.overlay-close').on('click', function(event) {
        $('.main-wrapper').removeClass('opens-about opens-contact');
    });

	$(".scroll-bottom").click(function() {
		if ($(this).hasClass("to-up")){
			$(".right-side").animate({ scrollTop: 0 }, 1000);
		} else {
			$(".right-side").animate({ scrollTop: $(".right-side").height() }, 1000);
		}

		$(this).toggleClass("to-up");		
	});

	$(".right-side").scroll(function(e){
		var el = $(this),
			pos = el.scrollTop(),
			off = $(this).position(),
			wh = window.innerHeight,
			max = $(".right-side-content").outerHeight() - wh,
			btn = $(".scroll-bottom");

		if (pos == 0) {
			btn.removeClass("to-up");
		} else {
			if ( parseInt(pos) == parseInt(max) ) {
				btn.addClass("to-up");
			}
		}
	});

    var resizeContent = {
        'init': function() {
            if ($('.contact-side-content .inside-content').length) {
                var $this               = $('.contact-side-content .inside-content'),
                    wh                  = $(window).height(),
                    heightContent       = $this.outerHeight(),
                    contactSidePadding  = parseInt($this.closest('.contact-side').css('padding-top'));

                if (heightContent >= (wh - (contactSidePadding * 2))) {
                    $this.parent().addClass('no-margin');
                } else {
                    $this.parent().removeClass('no-margin');
                }
            }

            if ($('.right-side-content').length) {
                var $this             = $('.right-side-content'),
                    wh                = $(window).height(),
                    heightContent     = $this.outerHeight(),
                    halfHeightContent = heightContent / 2;

                $this.css('margin-top', -halfHeightContent);

                if (heightContent >= wh) {
                    $this.addClass('no-margin');
					$(".scroll-bottom").show();
                } else {
                    $this.removeClass('no-margin');
					$(".scroll-bottom").hide();
                }

            }

            if ($('.about-side-content .inside-content').length) {
                var $this             = $('.about-side-content .inside-content'),
                    wh                = $(window).height(),
                    heightContent     = $this.outerHeight(),
                    aboutSidePadding  = parseInt($this.closest('.about-side').css('padding-top'));

                if (heightContent >= (wh - (aboutSidePadding * 2))) {
                    $this.parent().addClass('no-margin');
                } else {
                    $this.parent().removeClass('no-margin');
                }
            }

			setTimeout(function() {				
				if (!isMobile) {
					$(".right-side, .contact-side-content, .about-side-content").getNiceScroll().resize();
				}
			},100);
        }
    }

    resizeContent.init();

	if (!isMobile) {
		$(".right-side, .contact-side-content, .about-side-content").niceScroll({
			cursorcolor: "#14acd7",
			cursorwidth: "0px",
			cursorborder: "0px solid #14acd7",
			cursorborderradius: "0px",
			horizrailenabled: false
		});
	}

    $(window).resize(function() {
        resizeContent.init();
    });

});